<?php
/**
 * This file is part of
 *
 * SiriusGallery
 *
 * for pragmamx (www.pragmamx.org)
 *
 * $Revision: 1105 $
 * $Author: PragmaMx $
 * $Date: 2024-12-20 16:18:46 +0100 (Fr, 20. Dez 2024) $
 * 
 * *****************************************
 * Mise à jour le 20/04/2025 par Sébastien *
 * *****************************************
 * 
 */

 
// Admin
defined('mxMainFileLoaded') or die('access denied');
define("_MODULNAME", "Sirius Gallery");

// Toolbar
if (!defined("_REDIRECT")) define("_REDIRECT", "Clone");
if (!defined("_PICTURES")) define("_PICTURES", "Images");

// Installation
define("_SGINSTALL", "Installation");
define("_SGINSTALL_TITLE", "Installation la base de donnée");
define("_SGINSTALL_COMPLETE", "Installation terminée");
define("_SGINSTALL_TABLES", "Les tables suivantes ont étés crées / modifiés");
define("_SGINSTALL_INFO", "Vérifier la configuration dans la dernière étape et modifier là au besoin.");
define("_SGINSTALL_LINK", "Continuer à la configuration");
define("_SG_INSTALL_NOTHINGTODO", "Toutes les tables sont à jour.");

// Backend
define("_ADMINPANELTEXT", "Panneau de gestion Sirius Galerie");
define("_CPANEL", "Menu administration");
define("_SETTINGS", "Paramètres");
define("_MODULSETTINGS", "Réglages du module");
define("_CATEGORIES", "Albums");
define("_GOHOME", "Accueil");
langdefine("_BACK", "Retour");
define("_DOCUMENTATION", "Documentation");
// define("_HELP", "Aide");
// define("_CANCEL", "Annuler");
define("_GENERALSETTINGS", "Paramètres globaux");
define("_ACCEPT", "Accepter");
// define("_SIRIUSGALLERY", "Sirius Gallery");
define("_IMAGE_MANAGER", "Images");
define("_UPLOAD_MANAGER", "Envoyer des images");
define("_INFO", "Infos");
define("_TOOLS", "Ouitls");
//define("_PLUGINS", "Plugins");

// Info
define("_ADMIN_INFO", "Info");
define("_SAVED", "Modifications enregistrées");
define("_SAVED_AT", "Enregistré sur: ");

// Paramètres globaux
define("_CONF_GENERAL", "Paramètres globaux");
define("_CONF_GENERAL_RIGHTBLOCKS", "Autoriser les blocks de droite");
define("_CONF_GENERAL_TITLE", "Titre de la galerie");
define("_CONF_GENERAL_TITLE_TEXT", "Entrer le nom de la galerie, qui apparaitra en haut du module.");
define("_CONF_GENERAL_SPAW", "Utilser l'éditeur WYSIWYG");
define("_CONF_GENERAL_SPAW_TEXT", "Si activé, l'éditeur WYSIWYG est utilisé pour la saisie de texte dans le frontend. Sinon, seul un champ de saisie de texte est affiché. Les paramètres de l'éditeur WYSIWYG correspondent aux spécifications des paramètres PragmaMX <a href='admin.php?op=textarea'>Paramètres éditeur WYSIWYG</a>.");
define("_CONF_GENERAL_TEXT", "Entre une description");

// Répertoires
define("_CONF_DIRECTORIES", "Répertoires");
define("_CONF_DIRECTORIES_TEXT", "Ici, vous pouvez déterminer les chemins des dossiers dans lesquels vos images vont être enregistrées. En principe dans le répertoire de la galerie, mais vous pouvez changer ce paramètre. Si vous désirez mettre vos messages à la racine du site, vous ne devez pas mettre de slash '/'. Veuillez noter que les dossiers doivent êtres inscriptibles.");
define("_CONF_DIR_IMAGES", "Chemin vers les images");
define("_CONF_DIR_IMAGES_TEXT", "Chemin vers l'emplacement ou vous désirez stocker les images. Les images stockées dans ce répertoire seront utilisées pour la vue de détail des images.");
define("_CONF_DIR_TEMP", "Répertoire pour les fichiers temporaires");
define("_CONF_DIR_TEMP_TEXT", "Chemin vers le dossier pour stocker les fichiers des actions temporaires.");
define("_CONF_DIR_THUMB", "Chemin vers les miniatures");
define("_CONF_DIR_THUMB_TEXT", "Chemin vers l'emplacement de stockage des vignettes. Les vignettes générées automatiquement sont stockées dans ce répertoire. Les miniatures seront ensuite utilisées pour l'affichage dans l'aperçu de la galerie. ");
define("_CONF_DIR_FTP", "Chemin de téléchargement FTP");
define("_CONF_DIR_FTP_TEXT", "Répertoire qui sera utilisée lorsque vous désirerez effectuer des envois par FTP dans la galerie.");
define("_CONF_DIR_WATERMARK", "Chemin vers le logo du site");
define("_CONF_DIR_WATERMARK_TEXT", "Chemin vers le dossier qui contient le logo du site si vous activez cette fonction. .");
define("_CONF_DIR_FILE_WATERMARK", "Logo du site");
define("_CONF_DIR_FILE_WATERMARK_TEXT", "Nom du fichier du logo, vous pouvez le modifier. il doit s'agir d'un fichier « .png » à insérer dans le dossier \"logo du site\".");
define("_CONF_DIR_HIDDEN", "Cacher le chemin des images");
define("_CONF_DIR_HIDDEN_TEXT", "L'emplacement des images est cachée au navigateur. <b> Note: </ b> Cette option augmente le référencement des images mais elle sont plus difficile d'accès dans la galerie car elle n'apparaissent pas dans l'arbre.");

// Paramètres des utilisateurs
define("_CONF_USERSETTINGS", "Paramètres des utilisateurs");
define("_CONF_USERSETTINGS_TEXT", "Paramètres des utilisateurs");
define("_CONF_USER_USERGALLERY", "Autoriser les membres à avoir une galerie");
define("_CONF_USER_USERGALLERY_TEXT", "Sélectionner si un membre peut avoir une galerie, si non vous pouvez ignorer les options suivantes.");
define("_CONF_USER_MINPOINTS", "Minimum de points utilisateurs");
define("_CONF_USER_MINPOINTS_TEXT", "Entrez içi le minimum de points utilisateurs que doit avoir un membre avant de pouvoir créer un album. Entrez 'NULL' pour aucune restriction");

define("_CONF_USER_ADMIN", "Activation des images");
define("_CONF_USER_ADMIN_TEXT", "Si OUI, les membres qui ont envoyé des images doivent être validés au préalable par un administrateur avant de pouvoir apparaitre. Si NON, elles seront visibles immédiatement sur l'accueil de la galerie.");
define("_CONF_USER_ACCESSLEVEL", "Autoriser les membres à changer le niveau d'accès ");
define("_CONF_USER_ACCESSLEVEL_TEXT", "Autoriser les membres à changer le niveau d'accès dans l'apparence de son propre album.");
define("_CONF_USER_SORT", "Autoriser les membres à changer l'ordre des résultats");
define("_CONF_USER_SORT_TEXT", "Autoriser les membres à changer l'ordre des résultats.");
define("_CONF_USER_MAXCAT", "Maximum d'albums");
define("_CONF_USER_MAXCAT_TEXT", "Combien de catégorie peuvent êtres crées par un membres.");
define("_CONF_USER_MAXIMAGES", "Maximum d’images");
define("_CONF_USER_MAXIMAGES_TEXT", "Maximum d'images que que les membres peuvent envoyer. Le membre reçoit un message d'erreur et l'envoi du fichier n'a pas lieus.");
define("_CONF_USER_MAXIMAGESIZE", "Taille max. du fichier");
define("_CONF_USER_MAXIMAGESIZE_TEXT", "En kBytes. Taille maximum d'une image. Ceci n'affecte pas les envois par FTP !");
langdefine("_CONF_USER_MAXUPLOADS", "Nombre d'envois à la fois");
define("_CONF_USER_MAXUPLOADS_TEXT", "Définissez le nombre d'images qu'un membre peut envoyer d'un seul coup.");
define("_CONF_USER_UPLOADADMIN", "Activation par l'administrateur ?");
define("_CONF_USER_UPLOADADMIN_TEXT", "Les images doivent t’elles être approuvées par un administrateur ?");

define("_CONF_USER_USERPOINTS", "Points utilisateurs");
define("_CONF_USER_USERPOINTS_TEXT", "Si activé, la prise en compte des points utilisateurs sera activée");
define("_CONF_USER_UP_PIC", "Envois");
define("_CONF_USER_UP_COM", "Commentaires");
define("_CONF_USER_UP_VOTE", "Avis / Notes");
define("_CONF_USER_DELETE", "Supprimer les images orphelines des membres");
define("_CONF_USER_DELETE_TEXT", "Lorsqu'un utilisateur est supprimé du système, ses images deviennent orphelines. Si cette option est activée, lorsqu'un utilisateur est supprimé, les photos et les albums de l'utilisateur seront également supprimés. Les commentaires faits sur d'autres images par cet utilisateur resteront, mais seront affichés comme commentaires d'invités.");
define("_CONF_USER_TEMPLATE", "Autoriser les membres à modifier l'apparence");
define("_CONF_USER_TEMPLATE_TEXT", "Si activé, les membres peuvent changer l'apparence de leurs albums.");
define("_CONF_FRONT_BLOCKS_USERNAME", "Voir le nom de l’utilisateurs");
define("_CONF_FRONT_BLOCKS_USERNAME_TEXT", "Le nom de l'utilisateur doit-il apparaitre a côté de l'image ?");

define("_CONF_USER_ACCESS_INFO", "Ceci peut être utilisé dans le cas ou plusieurs groupes doivent avoir des informations différentes. Si \"le paramètre utilisé\" n'est pas sélectionné le groupe par défaut 'users' sera utilisé.");

define("_CONF_FRONT_BLOCKS_TITLE", "Montrer le titre des images");
define("_CONF_FRONT_BLOCKS_TITLE_TEXT", "Faut-il afficher le titre des images aux cotés des images ?");
define("_CONF_FRONT_BLOCKS_TITLEAUTO", "Titre généré automatiquement");
define("_CONF_FRONT_BLOCKS_TITLEAUTO_TEXT", "Les titres des blocs système doivent-ils êtres générés automatiquement ? Le changement de langue s'effectue automatiquement. Si cette option est désactivée, les titres des blocs du paramètre de bloc système sont utilisés.");

// Paramètres des images
define("_CONF_IMAGE_MANIPULATION", "Paramètres des images");
define("_CONF_IMAGE_GD_OK", "GD 2 est installé, la conversion des vignettes fonctionne.");
define("_CONF_IMAGE_GD_NONE", "GD-Version 2 n'est pas installé ou ne fonctionne pas correctement, la conversion des vignettes ne fonctionne pas.");
define("_CONF_IMAGE_SIZE", "Taille maximun des images");
define("_CONF_IMAGE_SIZE_TEXT", "Entrer la veuleur en (pixels) pour définir les dimensions maximales à appliquer à la hauteur et à la leurgeur de l'image. La face la plus grande sera utilisée pour redimensionner l'image proportionellement.");
define("_CONF_IMAGE_FILESIZE", "Poids maximum des images");
define("_CONF_IMAGE_FILESIZE_TEXT", "<b>(en kBytes)</b> Poids maximum des fichiers d'images.");
define("_CONF_IMAGE_MAXSIZE", "Taille maximum des images pour l'affichage dans la galerie");
define("_CONF_IMAGE_MAXSIZE_TEXT", "La valeur saisie (en pixels) spécifie la taille maximale de l'image et s'applique à la fois à la hauteur et à la largeur, c'est-à-dire que l'image est réduite proportionnellement à la valeur saisie, en commençant par son bord latéral le plus long. Ces images réduites sont ensuite utilisées pour les afficher dans la vue détaillée. Afin de ne pas « faire exploser » un modèle, il est conseillé de saisir une valeur adaptée au modèle.");
define("_CONF_IMAGE_QUALITY", "Qualité des images après le redimenssionnment");
define("_CONF_IMAGE_QUALITY_TEXT", "Cette option fonctionne uniquement si le redimensionnemnt (deux options au dessus) est activé. Entrez une valeur en pourcentage pour spécifier la qualité des images redimensionnées par rapport à l'image d'origine. Pensez qu'une qualité élevée prends plus d'espace sur le serveur.");
define("_CONF_THUMB_CONVERT", "Conversion des vignettes");
define("_CONF_THUMB_CONVERT_TEXT", "L'objectif de la conversion vignette est d'afficher toutes les pouces soit dans la même largeur ou la hauteur, sans mention du format d'image originale (portrait ou paysage). ");
define("_CONF_THUMB_CONVERT_0", "Largeur ou hauteur");
define("_CONF_THUMB_CONVERT_1", "Taille définie");
define("_CONF_THUMB_WIDTH", "Largeur maximum des vignettes");
define("_CONF_THUMB_WIDTH_TEXT", "Largeur maximum des vignettes pour la conversion en pixel. ");
define("_CONF_THUMB_HEIGHT", "Hauteur maximum des vignettes");
define("_CONF_THUMB_HEIGHT_TEXT", "Hauteur maximum pour la conversion des vignettes en pixel. ");
define("_CONF_THUMB_QUALITY", "Qualité des vignettes");
define("_CONF_THUMB_QUALITY_TEXT", "Entrez une valeur en pourcentage pour définir la qualité des vignettes en fonction de l'image d'origine. N'oubliez pas qu'une qualité élevée prends plus de place sur le serveur.");

define("_CONF_IMG_DOWNLOAD", "Autoriser le téléchargement");
define("_CONF_IMG_DOWNLOAD_TEXT", "Les visiteurs sont-ils autorisés à télécharger les images ? Si activer un bouton de téléchargement apparaitra aux cotés de l'image.");
define("_CONF_IMG_DOWNLOAD_USER", "Qui peut télécharger les images");
define("_CONF_IMG_DOWNLOAD_USER_TEXT", "Selectionnez qui peut télécharger les images.");
define("_CONF_IMG_WATERMARK", "Télécharger avec le logo");
define("_CONF_IMG_WATERMARK_TEXT", "Le logo doit-il apparaitre lorsque l'image est téléchargée ?");
define("_CONF_IMG_WATERMARK_POS", "Position du logo");
define("_CONF_IMG_WATERMARK_POS_TEXT", "A quel endroit désirez vous que le logo apparaisse ?");
// Frontend
define("_CONF_FRONTENDSETTINGS", "Paramètres des albums");
define("_CONF_FRONTENDSETTINGS_TEXT", "Ces paramètres s'appliquent aux albums et sous-albums.");
define("_CONF_FRONT_BREADCRUMP", "Montrer le chemin");
define("_CONF_FRONT_BREADCRUMP_TEXT", "Si le chemin vers la galerie est montré ? Afficher un chemin depuis l 'accueil de la galerie.");
define("_CONF_FRONT_DESCRIPTION", "voir la description de l'album");
define("_CONF_FRONT_DESCRIPTION_TEXT", "La description de l'album doit-elle apparaitre ?");
define("_CONF_FRONT_VIEWEMPTYCAT", "Montrer les catégories vides");
define("_CONF_FRONT_VIEWEMPTYCAT_TEXT", "Les catégories vides doivent-elles être montrés ?");
define("_CONF_FRONT_LISTS", "Afficher les stats");
define("_CONF_FRONT_LISTS_TEXT", "Désirez vous afficher les listes d'images les mieux notées', 'Les plus vues' etc...?");
define("_CONF_FRONT_LIST_COUNT", "Nombre d'images dans les listes");
define("_CONF_FRONT_LIST_COUNT_TEXT", "Nombre d'images à afficher dans les listes");
define("_CONF_FRONT_VIEWS", "Maximum d'images par page");
define("_CONF_FRONT_VIEWS_TEXT", "Maximum d'images à afficher sur une page. (0 = pas de limite)");
define("_CONF_FRONT_PAGES", "Montrer la navigation");
define("_CONF_FRONT_PAGES_TEXT", "Si un systeme de navigation est nécessaire, où doit-il apparaitre.");
define("_CONF_FRONT_PAGES_TOP", "En haut");
define("_CONF_FRONT_PAGES_BOTTOM", "En bas");
define("_CONF_FRONT_PAGES_BOTH", "En haut en bas");
define("_CONF_FRONT_CATEGORIES", "Nombre d'albums");
define("_CONF_FRONT_CATEGORIES_TEXT", "Le total des albums doit il apparaitre en dessous de la navigation ?");
define("_CONF_FRONT_IMAGES", "Nombre d'images");
define("_CONF_FRONT_IMAGES_TEXT", "Le nombre d'albums doit-il etre affiché ? si oui, toutes les sous albums et les images qui sont à l'intérieur seront comptabilisés.");
define("_CONF_FRONT_TEMPLATE", "Apparence");
define("_CONF_FRONT_TEMPLATE_TEXT", "Choississez quelle apparence vous désirez utiliser pour la galerie. Cette apparence sera définie par défaut pour tous les albums et sous albums, mais chaque album peut néanmoins arborer une apparence spécifique.");
define("_CONF_FRONT_SLIDESHOW", "Défilement d'images ");
define("_CONF_FRONT_SLIDESHOW_TEXT", "Choisissez que type de diaporama vous désirez utiliser.");
define("_CONF_FRONT_SLIDSHOW_LINK", "Montrer un lien vers le défilement d'images");
define("_CONF_FRONT_SLIDSHOW_LINK_TEXT", "Un lien vers le défilement d'images doit-il apparaitre ?");
define("_CONF_FRONT_SLIDESHOWCOLOR", "Couleur de l'arrière plan du défilement d'images");
define("_CONF_FRONT_SLIDESHOWCOLOR_TEXT", "Vous devez entrer un paramètre hexadécimal pour définr la couleur de l'arrière plan du défilement d'images.");
// Gallery general
define("_CONF_GALLERY_GENERAL", "Configuratoin des albums");

define("_CONF_CATEGORY_GENERAL", "Configuratoin des albums");
define("_CONF_CATEGORY_GENERAL_TEXT", "Ces paramètres sont utilisés pour l'apparence des albums..");
define("_CONF_CAT_TEMPLATE", "Apparence de l'aperçu des images");
define("_CONF_CAT_TEMPLATE_TEXT", "Choissisez l'apparence que vous désirez utiliser pour l'aperçu des images.");
define("_CONF_CAT_SLIDESHOW", "Montrer le défilement d'images");
define("_CONF_CAT_SLIDESHOW_TEXT", "Si activé, un bouton s'affichera pour lancer le diaporama.");
define("_CONF_CAT_SLIDE_SELECT", "Selectionnez un diaporama");
define("_CONF_CAT_SLIDE_SELECT_TEXT", "Sélectionnez le diaporama à utiliser. Ces informations ne sont pertinentes que si « Afficher le diaporama » a été sélectionné.");
define("_CONF_CAT_INFO_TEXT", "Les informations fournies s'appliquent à l'apparence par défaut en écraseront les paramètres d'apparence existants.");
// Settings Deatil
define("_CONF_DETAIL_GENERAL", "Vue détaillé des images");
define("_CONF_DETAIL_GENERAL_TEXT", "Ces paramètres définissent l'apparence de la vue de \"details \" des images");
define("_CONF_CAT_DETAIL", "Voir le détail de l'image lors du clic");
define("_CONF_CAT_DETAIL_TEXT", "Si activé, les utilisateurs peuvent voir le détail de l'image lors du clic");
define("_CONF_USER_INFO", "Les paramètres suivants sont effectifs seulement si l'aperçu du détail des images est activé. Ils dépendent également des paramètres d'apparence. ");
define("_CONF_USER_VOTING", "Autoriser les votes");
define("_CONF_USER_VOTING_TEXT", "Si cette option est sélectionnée, un formulaire d'évaluation apparaitra.");
define("_CONF_USER_VOTING_MAX", "Chiffre de la meilleure notre possible");
define("_CONF_USER_VOTING_MAX_TEXT", "Entrer un nombre pour définir le niveau de la meilleur note possible ");
define("_CONF_USER_COMMENTS", "autoriser les commentaires");
define("_CONF_USER_COMMENTS_TEXT", "Les membres seront autorisés à diffuser des commentaires dans un champs approprié qui apparaitra dans la vue détaillée des images. vous trouverez des paramètres additionnels dans les 'Paramètres des commentaires'");
define("_CONF_USER_RIGHTCLICK", "Désactiver le clic droit");
define("_CONF_USER_RIGHTCLICK_TEXT", "Si cette option est activée, le clic droit sera bloqué");
define("_CONF_DETAIL_INFO", "Les données ci-dessous peuvent être affichés sur la page de détail où ils sont effectivement présents. La description est toujours affichée. La note est toujours affiché si la cote est autorisée (voir option ci-dessus)");
define("_CONF_DETAIL_FILESIZE", "Taille de l'image");
define("_CONF_DETAIL_VIEWS", "Nombre de vues");
define("_CONF_DETAIL_DATE", "Date d'ajout");
define("_CONF_DETAIL_UNAME", "Nom du membre");
define("_CONF_DETAIL_AUTHOR", "Propriétaire/Auteur");
define("_CONF_DETAIL_KEYWORDS", "Mots clés");
// Comments
define("_CONF_COMMENT_GENERAL", "Paramètres des commentaires");
define("_CONF_USER_COMMENTS_NEWESTFIRST", "Plus récent en premier");
define("_CONF_USER_COMMENTS_NEWESTFIRST_TEXT", "Si acticé les commentaires s'afficheront du plus récent au plus ancien plutot que l'inverse.");
define("_CONF_USER_COMMENTS_GUEST", "Autoriser les commentaires des visiteurs");
define("_CONF_USER_COMMENTS_GUEST_TEXT", "Si sélectionné, les visiteurs auront la possibilité de laisser des commentaires. ");
define("_CONF_COMMENT_GENERAL_TEXT", "Paramètres des commentaires");
define("_CONF_USER_COMMENTS_ADMIN", "Approbation par un webmaster");
define("_CONF_USER_COMMENTS_ADMIN_TEXT", "Normalement les commantaires sont publiés instantanéments. Ce paramètre peut etre modifié si vous déisirez qu'un webmaster controle le contenu des commentaires avant publication. (Dans ce cas le  webmaster est averti par e-mail).");
define("_CONF_USER_CAPTCHA", "Utiliser la vérification visuelle ");
define("_CONF_USER_CAPTCHA_TEXT", "Si activé, un image de vérification visuelle apparaitra pour les envois, les commenraires, les descriptions, les sondages etc... ceci est un moyen de prévention contre le spam, etc.. Vous pouvez régler les <a href='admin.php?op=captcha'> Paramètres de la vérification visuelle </ a> ");
define("_CONF_USER_CAPTCHA_USER", "Utiliser la vérification visuelle pour les membres");
define("_CONF_USER_CAPTCHA_USER_TEXT", "Si activé, les membres seront soumis au code de vérification visuelle");
define("_CONF_USER_COOKIE", "Utiliser un cookie pour les utilisateurs");
define("_CONF_USER_COOKIE_TEXT", "Si cette option est activée, le navigateur vérifie si les cookies sont acceptés par les utilisateurs non connectés et, si cela n'est pas possible, un message d'erreur s'affiche. Ceci permet de garantir que les cookies peuvent effectivement être installés.");

define("_CONF_BLOCK_SETTINGS", "Paramètres des blocs");
define("_CONF_FRONT_BLOCKS", "Voir les blocs");
define("_CONF_FRONT_BLOCKS_TEXT", "Si activé, plusieurs blocs sont affichés en dessous des albums");
define("_CONF_FRONT_BLOCKS_SUBS", "Blocs dans les sous albums");
define("_CONF_FRONT_BLOCKS_SUBS_TEXT", "Si activé, les blocs seront affichés dans les sous-albums.");
define("_CONF_FRONT_BLOCKS_USER", "Blocs dans les sous-albums des membres");
define("_CONF_FRONT_BLOCKS_USER_TEXT", "Si activé, des blocks seront affichés dans les albums des membres.");
define("_CONF_FRONT_BLOCKS_ACTUAL_CAT", "Mise à jour des blocs");
define("_CONF_FRONT_BLOCKS_ACTUAL_CAT_TEXT", "Si choisi, les blocs afficheront le contenu des sous albums dans les albums");
define("_CONF_FRONT_BLOCK", "Bloc :");
define("_CONF_FRONT_BLOCKS_COUNT", "Images par bloc");
define("_CONF_FRONT_BLOCKS_COUNT_TEXT", "Définissez combien d'images il doit y avoir dans un bloc");

define("_CONF_MESSAGE_GENERAL", "Messages");
define("_CONF_MESSAGE_GENERAL_TEXT", "Voici les informations de notification du webmaster.");
define("_CONF_MESSAGE_EMAIL", "Courriel");
define("_CONF_MESSAGE_EMAIL_TEXT", "Différent courriels peuvent être utilisés en tant que récepteur du message. Si cette case est vide, l'adresse du système sera utilisée.");
define("_CONF_MESSAGE_PICTURE", "Recevoir un courriel lors de l'envoi d'image");
define("_CONF_MESSAGE_PICTURE_TEXT", "Désirez-vous recevoir un courriel lors de l'envoi d'image ?");
define("_CONF_MESSAGE_COMMENT", "Envoie d’uncourriel pour l'ajout de commentaire");
define("_CONF_MESSAGE_COMMENT_TEXT", "Désirez-vous recevoir un courriel pour lorsque que quelqu'un ajoute un commentaire  ?");
define("_CONF_MESSAGE_NONE", " Non ");
define("_CONF_MESSAGE_APPROVAL", "Seulement pour les commentaires en attente d'approbation");
define("_CONF_MESSAGE_ALL", "Oui, pour tous ");

define("_CONF_EXT_FUNCTIONS", "Autres fonctions");
// -------------------------------------------------------------------------------
// Category edit
define("SG_CATEGORY_SETTINGS", "Paramètres de l'albums");
define("SG_CATEGORY_SETTINGS_TEXT", "Içi vous pouvez définir les paramètres de l'album.");
define("SG_CATEGORY_TITLE", "Titre");
define("SG_CATEGORY_TITLE_TEXT", "Entrer un titre d'album.");
define("SG_CATEGORY_DESCRIPTION", "Description");
define("SG_CATEGORY_DESCRIPTION_TEXT", "");
define("SG_CATEGORY_PARENT", "Album parent");
define("SG_CATEGORY_PARENT_TEXT", "Dans quel album parent cet album doit-il etre rangé");
define("SG_CATEGORY_PUBLISH", "Publier ");
define("SG_CATEGORY_PUBLISH_TEXT", "Publier dans cet album indépendamment des albums parents et enfant.");
define("SG_CATEGORY_ACCESS", "Qui peut voir cet album ");
define("SG_CATEGORY_ACCESS_TEXT", "Définiissez qui peut consulter cet album.");
define("SG_CATEGORY_USER", "Créateur/propriétaire");
define("SG_CATEGORY_USER_TEXT", "Entrez le propriétaire de cette album. Attention, si cette albums, est dans la racine. Vous ne devriez utiliser cette option que pour des albums spécifiques.");
define("SG_CATEGORY_SORTORDER", "Tri des albums");
define("SG_CATEGORY_SORTORDER_TEXT", "Entrez içi, comment les albums doivent-ils etres ordonnées.");
define("SG_PIC_SORTORDER", "Tri des images");
define("SG_PIC_SORTORDER_TEXT", "Indiquez comment les images sont triés dansns l'album.");

define("SG_CATEGORY_ALBUMTHUMB", "Vignette");
define("SG_CATEGORY_ALBUMTHUMB_TEXT", "Choisissez quelle image doit-être utilisée comme vignette pour cette album.");
define("SG_CATEGORY_ALBUMTHUMB_0", "Image la plus récente ");
define("SG_CATEGORY_ALBUMTHUMB_1", "Image au hasard ");
define("SG_CATEGORY_PASS", "Mot de passe");
define("SG_CATEGORY_PASS_TEXT", "Merci d'entrer un mot de passe si l'accès à cet album doit-etre protégé par un mot de passe. ");
define("SG_CATEGORY_PASSHINT", "Indication de mot de passe");
define("SG_CATEGORY_PASSHINT_TEXT", "Entrez un mémo qui vous aidera à vous souvenir de votre mot de passe. ");

define("_SG_CATEGORY_TEMPLATE_DEFAULT", "- Paramètres du système -");

define("SG_CATEGORY_GENERAL_TEXT", "Les paramètres suivants sont effectifs seulement si ils sont défini au préalable dans les paramètres globaux du module et des paramètres d'apparence associés");
define("SG_CATEGORY_COMMENTS", "autoriser les commentaires");
define("SG_CATEGORY_COMMENTS_TEXT", "Désirez vous autoriser les commentaires dans cet album.");
define("SG_CATEGORY_VOTES", "Autoriser les votes");
define("SG_CATEGORY_VOTES_TEXT", "Indiquez ici si la notation des images dans cette catégorie est autorisée.");

define("SG_CAT_DELETE_INFO1", "Etes vous sur de vouloir supprimer cet album ? Sinon, veuillez décocher la case associée.");
define("SG_CAT_DELETE_INFO2", "Toutes les sous albums et images qu'ils contienne ne sont pas supprimés mais ont étés déplacé dans l'album parent de l'album supprimé. Les images contenues dans les albums supprimés sont orphemines. ");
// Upload
//define("_SG_UPLOAD_FIELD", "Envoyer des images ");
//define("_SG_UPLOAD_FIELD_TEXT", "Selectionnez des images et identifiez un catégorie dans laquelle les images doivent etres envoyés. Si le titre n'est pas choisi le nom du fichier de l'image sera utiliséen tant que titre.");

/*define("_SG_UPLOAD_SELECTFILE", "selectionner...");
define("_SG_UPLOAD_AUTHOR", "Auteur (optionnel)");
define("_SG_UPLOAD_DESCRIPTION", "Description (optionnel)");
define("_SG_UPLOAD_KEYWORDS", "Mots clés (optionnel)");
define("_SG_UPLOAD_KEYWORDS_TEXT", "");
define("_SG_UPLOAD_RESULT", "Les images suivantes ont étés ajoutés avec succès dans notre site.");

define("_SG_UPLOAD_NR", "N°");
define("_SG_UPLOAD_PIC", "Image");
define("_SG_UPLOAD_NAME", "nom de fichier");
define("_SG_UPLOAD_TITLE", "Titre");
define("_SG_UPLOAD_FILESIZE", "Taille en KBytes");
define("_SG_UPLOAD_MIME", "MIME-Typ");
define("_SG_UPLOAD_OK", "Resultat");
define("_SG_UPLOAD_UPLOADNAME", "Nom de l'envoi");
// FTP Upload
define("_SG_UPLOAD_FTP", "envoi-FTP");
define("_SG_UPLOAD_SELECT", "Type d'upload");
define("_SG_UPLOAD_FTPFIELD_TEXT", "Selectionnez des images et choissiez dans quelle catégorie elles doivent etres envoyées. Le nom de fichier est utilisé en tant que titre, le nom de l'auteur est optionnel. Si les images sont enoyées dans le répertoires d'un membres, elle seront considéré comme appartenant à celui ci.");
define("_SG_UPLOAD_FTPDELETE", "Supprimer les images ?");
define("_SG_UPLOAD_FTPDELETE_TEXT", "Images à supprimer les images après insertion dans via FTP");
define("_SG_UPLOAD_FTPPATHINFO", "Images dans le répertoire de stockage FTP ");
define("_SG_UPLOAD_PATHEMPTY", "aucune information correcte !");*/

// Images Edit
define("_PIC_PROPERTIES", "Propriétés");
define("_SG_IMG_TITLE", "Titre");
define("_SG_IMG_OWNER", "Propriétaire");
define("_SG_IMG_AUTHOR", "Droits / Auteur");
define("_SG_IMG_DESCRIPTION", "Description");
define("_SG_IMG_FILENAME", "Nom d'origine de l'image");
define("_SG_IMG_KEYWORDS", "Mots clés");
define("_SG_IMG_UPLOADDATE", "Envoyée le ");
define("_SG_IMG_FILESIZE", "Taille de fichier");

define("_SG_IMG_SUM_WEHAVE", " Il y a  ");
define("_SG_IMG_SUM_PICTURES", "images que vous pouvez trier.");
define("_SG_IMGDEL_WARNING", "Les images sélectionnées vont être supprimées. Vous pouvez désélectionner individuellement les images.");

define("_SG_IMGCOPY_INFO", "Les images sélectionnées sont copiées, ainsi que leurs vignettes et les tailles intermédiaires. Si vous choisissez un album, toutes les images seront copiées dans cet album, vous pouvez déselectionner individuellement les images.");
define("_SG_IMGCLONE_INFO", "Selectionnez les images à copier dans la base de données, aucune fichier n'est créé. Si vous choisissez un album, les images seront copiés dans cet album, vous pouvez aussi déselectionner individuellement les images.");
define("_SG_IMGMOVE_INFO", "Sélectionnez les images qui doivent etres déplacées dans l'album choisi. Vous pouvez déselectionner individuellement les images. ");

define("_PICTURES_MOVED", "Les images ont été déplacées");

define("_PICTURES_COPIED", "Les images ont été copiées");
define("_PICTURES_CLONED", "Images clonées");
define("_SG_CLONE", "Clone");

define("_SG_COM_SUM_WEHAVE", " Il y a ");
define("_SG_COM_SUM_PICTURES", "Commentaires à trier.");
define("_SG_COMDEL_WARNING", "Les commentaires sélectionnés seront supprimés, vous pouvez également déselectionner individuellement les commentaires. ");
// FORM
define("_USER_ALL", "Tous");
define("_USER_NO", "Non");
define("_USER_REGISTRED", "Uniquement les membres");
define("_USER_ADMIN", "Administrateursrs");
define("_USER_SUPERADMIN", "Super-utilisateurs");
define("_USER_GUEST", "Visiteurs");
define("_USER_REGISTRED_ONLY", "Uniquement les membres");
define("_USER_ADMIN_ONLY", "Uniquement les administrateurs");
define("_USER_GUEST_ONLY", "Uniquement les visiteurs");
define("_USER_AND_REGISTRED", "Visiteurs et membres");

define("_SORT_ORDER_DATE_ASC", "Date ascendante");
define("_SORT_ORDER_DATE_DESC", "Date descendante");
define("_SORT_ORDER_RATING", "Note");
define("_SORT_ORDER_VIEWS", "Vues");
define("_SORT_ORDER_ALPHA_ASC", "Alpha ascendant");
define("_SORT_ORDER_ALPHA_DESC", "Alpha descendant");

define("_SG_JOIN_NONE", "Non");
define("_SG_JOIN_JUSTME", "Uniquement le propriétaire");
define("_SG_JOIN_USER", "Les membres");
define("_SG_JOIN_ALL", "Tous le monde");
// Toolbar
define("_ERR_NOACTIONLIST", "Merci de faire un choix");
define("_PUBLISH", "Publier");
define("_UNPUBLISH", "Dépublier");

define("_PARENTCATEGORY", "Dans l'album");
define("_OWNER", "Propriétaire");
// Error
define("_SG_ERROR", "Erreur");
define("_ERR_DIR_IO", "Chemin accessible en  écriture");
define("_ERR_DIR_NIO", "Chemin non accessible en écriture");
define("_SG_ERR_UPLOAD_ERR_OK", "OK");
define("_SG_ERR_UPLOAD_ERR_NIO", "Erreur lors de l'envoi");
define("_SG_ERR_UPLOAD_ERR_INI_SIZE", "Fichier trop gros ");
define("_SG_ERR_UPLOAD_ERR_FORM_SIZE", "Fichier trop gros ");
define("_SG_ERR_UPLOAD_ERR_PARTIAL", "Le fichier n'à été que partiellement envoyé. ");
define("_SG_ERR_CAT_TITLE_EMPTY", "Entrez un Titre");
define("_SG_ERR_UPLOAD_ERR_FILESIZE", "La taille de l'image dépasse les limites autorisées");
define("_SG_ERR_UPLOAD_ERR_TYPE", "Cette extension de fichier n'est pas autorisée");
// Frontend
define("_CATEGORY_INDEX", "Accueil");
// allgemeine W&ouml;rter
if (!defined("_FILTER")) define("_FILTER", "Filtrer");
define("_TNEXT", "suivant");
define("_LIMIT", "N°./page");
// define("_SG_PICTURE", "Image");
// Filterfunktionen Bilder
define("_DATE_DESC", "Date ascendante");
define("_DATE_ASC", "Date descendante");
define("_USER_ASC", "Membre ascendant");
define("_USER_DESC", "Membre descendante");
define("_VIEWS_ASC", "Vues ascendante");
define("_VIEWS_DESC", "Vuess descendante");
define("_PIC_ASC", "Image ascendante");
define("_PIC_DESC", "Image descendante");
define("_SG_SORT_CAT", "Albums");
define("_PUBLISHED", "Publié");
define("_UNPUBLISHED", "En attente de publication");
define("_SG_SORTBY", " Trier par ");

define("_NEXTPAGE", "->");
define("_PREPAGE", "<-");
define("_FIRSTPAGE", "|<");
define("_LASTPAGE", ">|");
define("_PICTURES_DELETED", "Images supprimées");
define("_COMMENTS_DELETED", "Les commentaires ont été supprimés");
define("_SG_COUNT", "No.<br>cat/Images");
define("SG_NOCATEGORY", "{<i>Pas d'album</i>}");
define("_RANDOM", "Au hasard");
define("_LASTPICTURE", "Dernière image envoyée");
define("_USERAVATAR", "Avatar du propriétaire <div class=\"tiny\">(Si il n'y a pas de propriétaire ou pas d'images, un images au hasard sera utiliséeif no owner present, or no image, then used a random image)</div>");
define("_CATEGORYIMAGES", "Images de l'album");

define("_TOP_RIGHT", "En haut à droit");
define("_TOP_LEFT", "En haut à gauche");
define("_BOTTOM_RIGHT", "En bas à droit");
define("_BOTTOM_LEFT", "En bas à gauche");
// define("_TOP","en haut");
define("_BOTTOM", "Bas");
define("_LEFT", "Gauche");
define("_RIGHT", "Droite");
define("_CENTER","Centré");
define("_SG_NOCHANGE", "Aucun changement");
// define("_POINTS","Punkte");
define("_SG_PROTECTED", "Protection par mot de passe");
define("_SG_GOHOME", "Accueil");
define("_SG_EMPTY", "-- Vide --");
define("_SG_NEW_WAITING", "en attente");
// define("_SG_NAME", "Nom");

define("_SG_COMMENTS_WAITING", "Commentaires en attente d'approbation");
define("_SG_PIC_WAITING", "Images en attente d'approbation");
// Tools
define("_SG_CONVERT", "Conversion");
define("_SG_CONVERT_INFO", "Editer les paramètres de l'image pendant le processus de conversion qui peut prendre quelques minutes.");
define("_SG_TOOLS_INFO", "Merci de choisir une action. <b> Note: Toutes les actions, marqués comme importantes seront executées sans confirmations </b>!");
define("_SG_START", "Démarrer");
define("_SG_TOOLS_TEMPLATESDEFAULT", "Ajustez les valeurs des albums aux paramètres par de défaut de la configuration");
define("_SG_TOOLS_CONFIG_TEMPLATE", "Apparence");
define("_SG_TOOLS_CONFIG_COMMENTS", "Diffusion de commentaires");
define("_SG_TOOLS_CONFIG_VOTINGS", "Notations");
define("_SG_TOOLS_CONFIG_SORT", "Tri/Albums");

define("_SG_TOOLS_TEMPLATESDEFAULT_INFO", "Les valeurs par défaut ont étés rétablies dans toutes les catégories.");
define("_SG_TOOLS_UPDATERATINGALL", "Recalculer toutes les nouvelles notes ");
define("_SG_TOOLS_UPDATERATINGALL_INFO", " Toutes les notes ont été recalculées.");
define("_SG_TOOLS_DELETERATINGALL", "Supprimer tous les avis");
define("_SG_TOOLS_DELETERATINGALL_INFO", "Tous les avis ont été supprimés.");
define("_SG_PICCONVERT", "Conversion des vignettes et des images de taille intermédiaire");
define("_SG_PICCONVERT_INFO", "Toutes les vignettes et images de tailles intérmédiaires ont étés recrées");
define("_SG_PICTURES", "Images");
define("_NEXT", "Suivantes");
define("_FOR", "Pour");
define("_SG_CONVERTED", "Converties");

define("_SG_TOOL_CONVERT_CPG", "Convertir tous les albums et les photos depuis la galerie Coppermine Gallery dans Sirius Gallery. Les albums et images déjà importées ne seront pas réimportés. L'import concerne uniquement les images, et non pas les vidéos ou autres documents.");
define("_SG_CPG_ALBUM", "Albums et ");
define("_SG_CPG_FROM", "À partir de la galerie Coppermine ");

define("_SG_IMG_VIEWS", "Vues");
define("_SG_IMG_RATING", "Notes");

define("_SG_USE", "Utiliser");
define("_SG_GROUP", "Groupe de membres");
// add V 1.1
define("_CONF_USER_UPLOADFREE", "Envoyer dans les albums publics");
define("_CONF_USER_UPLOADFREE_TEXT", "Autoriser les membres à envoyer des images dans les albums publics ? Les albums publics n'ont pas de propriétaire !");

define("_CONF_USER_UPLOADPUBLISH", "Publier instantanément les images ?");
define("_CONF_USER_UPLOADPUBLISH_TEXT", "Si 'OUI', les images envoyées seront publiées directement. <b>Ne fonctionne pas dans le cas d'une activation par l'administrateur! </b>");
define("_CONF_USERGROUPSETTINGS", "Paramètres des groupes de membres");
define("_CONF_USERPOINTS", "Paramètres des points utilisateurs");

define("_TOOLS_CPGPFAD", "Nom du module coppermine");
define("_TOOLS_CPGIMPORTIMGCOPY", "Copier toutes les images dans le dossier d'images de SirusGallery");
define("_TOOLS_CPGIMPORTGALLERY", "Importe les albums des membres");
define("_TOOLS_CPGNEWFOLDER", "Créer un dossier séparé pour chaque album");

/* V 1.6. */
define("_CONF_FRONT_COPY_LINK", "Afficher le droit d'auteur");
define("_CONF_FRONT_COPY_LINK_TEXT", " Lorsque cette option est activée, le logo du droit d'auteur sera affiché. VEUILLEZ NOTER LES DIRECTIVES DE LICENCE !!");
define("_SORT_ORDER_POS_ASC", "Par la position");
define("_SG_POSITION", "Pos.");
define("_SG_POSITION_SAVE", "Enregistrer l'ordre");
define("_SG_SUBCAT_ORDER", "Définition des sous-catégories");
define("_SG_SUBCAT_ORDER_TEXT", "Si le paramètre \"Trier par Position\" est spécifié ici, l'ordre des sous-catégories sont listées. S'il vous plaît indiquer ici l'ordre numérique souhaitée");
define("_SG_SUBCAT_ORDER_INFO", "Le tri des sous-catégories que vous pouvez variable dans chaque catégorie ou avec le filtre (voir ci-dessus).");

define("_CONF_DEV_INFO", "Infos");
define("_CONF_DEV_INFO_TEXT", " Les informations sur le développeur doivent-elles être affichées?");

/* V 1.7 */

define("_SG_WIDTH", "Largeur");
define("_SG_HEIGHT", "Hauteur");
define("_SG_DOWNLOAD", "Télécharger");
define("_CONF_FACEBOOK", "Lien social");
define("_CONF_FACEBOOK_TEXT", " Un lien de réseau social doit-il être intégré?");
define("_CONF_EXIF", "Les données EXIF");
define("_CONF_EXIF_TEXT", "Voici la marque EXIF de données, qui sera affiché si l'image existe");
define("_CONF_EXIF_ACTIV", "Activer EXIF");
define("_CONF_USERLINK", "Liens pour l'utilisateur");
define("_CONF_USERLINK_TEXT", "Lorsqu'elle est activée - seulement pour le propriétaire - de l'image affichée divers codes BB pour la liaison des images.");
define("_SG_USEIPTC", "Les données IPTC utiliser");
define("_SG_USEIPTC_TEXT", "Si toutes les données IPTC stockées pour les titres, du texte, des mots clés, etc peut être utilisé?");

define("_CONF_SHARETHIS_KEY", "Key");
define("_CONF_SHARETHIS_KEY_TEXT", "Il utilise un plugin de <a  href='http://www.sharethis.com'>ShareThis.com </a>. Il est une application créée par un éditeur-Key. Cela peut être entré ici. Pour la fonction du plugin, mais la clé n'est pas nécessaire.");
define("_INSERT", "insérer");
define("_INSERTIPTC", "IPTC insert");
define("_DELETEIPTCDATA", "Les données IPTC à supprimer à partir du fichier d'image");
define("_IPTC2IMAGE", "Rendre les données IPTC à la description d'image");
define("_IPTC2IMAGEADD", "Les données d'image à l'IPTC supplément de données");
define("_IMAGE2IPTC", "Accepter les données de la description de l'image dans les données IPTC");
define("_SAVEIPTC", "Les données IPTC dans le magasin d'images");
define("_IPTC_TEXT", "Ces données IPTC stockées dans le fichier image. Les changements peuvent être mis à jour dans le fichier image et affichées dans la galerie");
// V 1.7.1
define("_PICTURES_UPDATED", "Images changé");
define("_SG_EDITMORE_INFO", "Les images sélectionnées sont sujettes à changement. Il peut également s'agir d'images non sélectionnés.");
define("_SG_EDITMORE_INFOTEXT", "Remplir les champs sont ajoutés à l'information d'image.");
define("_SG_OVERWRITE", "Ecraser les données existantes");
define("_SG_EDITMORE_INFOWARNING", "Remarque: Si la boîte est vide et 'override' est activée pour ce domaine, le contenu actuel de ce domaine sera supprimé.");
// V 1.8.
//define("_SG_UPLOAD_MULTISELECT", "Sélectionnez Fichiers");
//define("_SG_FILES_QUEUE", "Les fichiers dans la file d'attente");
//define("_SG_MULTIUPLOAD", "Téléchargez Script");
//define("_SG_MULTIUPLOAD_TEXT", "Ici, vous pouvez sélectionner plusieurs fichiers et les télécharger. Fichiers téléchargés seront dans la file et peut être édité.");
define("_PICTURES_RESIZE", "Reconstitution");
define("_PICTURES_RESIZE_TEXT", "Reconstruire les vignettes et la taille intermédiaire");
define("_PICTURES_RESIZE_COMPLETE", "Les images ont été re-calculé et re-crée les tailles intermédiaires.");
define("_PICTURES_RESIZE_INFO_1", "Les images sélectionnées seront recréés taille intermédiaire et les vignettes. Il peut également s'agir d'images non sélectionnés.");
define("_PICTURES_RESIZE_MAXCONVERT", " Un nombre maximum d’ images peuvent être converties en fonction des paramètres serveur. Vous avez sélectionnez drop d'images. Recommencez le processus en plusieurs fois avec les images sélectionnés.:");

define("_CONF_ADMIN_MAXIMAGES", "Administrateur Max. photos");
define("_CONF_ADMIN_MAXIMAGES_TEXT", " Spécifiez ici combien d'images les administrateurs sont autorisés à télécharger dans le frontend. Dans le backend, les administrateurs peuvent télécharger de manière illimitée.");
//define("_SG_MULTIUPLOAD_ALLDESC_TEXT", "Les données que vous fournissez ici seront utilisés dans le monde pour tous les fichiers lorsque les données sont laissées en blanc pour les fichiers de la file d'attente. Les mots-clés ici sont ajoutés à tous les fichiers.");
//define("_SG_MULTIUPLOAD_ALLDESC_TEXT2", "Ici vous pouvez entrer les données pour les images. Blank seront remplacées par les données mondiales. Non spécifié une catégorie dans le fichier ou dans les données globales, et non pas l'image est stockée dans la base de données. Il reste dans la file d'attente. Toute entrée est également stockée dans le fichier image si le type d'image permet cette (fonctionne seulement sur les fichiers JPEG et PNG).");

/*define("_SG_UPLOAD_TITLE_PREFIX", "préfixe du titre");
define("_SG_UPLOAD_TITLE_PREFIX_TEXT", "Est mis en avant tous les titres.");
define("_SG_UPLOAD_TITLE_SUFFIX", "suffixe du titre");
define("_SG_UPLOAD_TITLE_SUFFIX_TEXT", "Est rajouté à toutes les tuiles.");*/
// 1.8.1
define("_CONF_FRONT_INDEX", "La galerie de l'utilisateur est l'index");
define("_CONF_FRONT_INDEX_TEXT", " Si cette option est activée, la galerie utilisateur sera utilisée comme page de démarrage du module. Les catégories publiques ne sont plus affichées!");

define("_SG_TOOLS_CHECKDATABASE", "Base de données de service");
define("_CONF_USER_UPLOADEXT", "Amélioration Télécharger");
define("_SG_TOOL_CONVERT_EG", "Convertit tous les albums et photos de My_eGallery vers SiriusGallery. Les catégories ou images déjà importées ne sont pas insérées deux fois. Seules des photos sont prises, pas de vidéos et autres documents.");
define("_SG_EG_ALBUM", "Catégories et");
define("_SG_EG_FROM", "De l'eGallery");
define("_TOOLS_EGPFAD", "Nom du module de My_eGallery");
define("_TOOLS_EGIMPORTIMGCOPY", "Copiez toutes les images dans le dossier SiriusGallery.");


define("_SG_ASC", "Ascendant");
define("_SG_DESC", "Descendant");
define("_SG_PICCHECK","Vérifier les images");
define("_SG_PICCHECKED","Images vérifiées");
define("_SG_PICCHECK_INFO","Toutes les images sont vérifiées. Les entrées de base de données orphelines sont supprimées. Les fichiers image manquants sont réparés si nécessaire, sinon supprimés.");

define("_SG_TOOLS_DELETEDESERTED","Supprimer les images orphelines.");
define("_SG_TOOLS_DELETEDESERTED_INFO","Répertoire nettoyé : ");
define("_SG_TOOLS_DELETEDESERTED_INFO2"," Fichiers supprimés");

// Blockeinstellungen neu
define("_CONF_CATHIDDEN"," Catégories interdites ");
define("_CONF_CATHIDDEN_INFO","Spécifiez les identifiants de catégorie, séparés par des virgules, à partir desquels aucune image ne doit être affichée. ");
define("_CONF_COLLECTION_SELECT"," Sélection d'images ");
define("_CONF_COLLECTION_SELECT_INFO"," sélectionnez ici les images à afficher.");
define("_CONF_GALLERY_LINK"," Afficher le lien de la galerie?");
define("_CONF_GALLERY_LINK_TEXT"," Un lien vers la galerie doit-il être affiché?");
define("_CONF_BLOCK_SLIDESHOW_TEXT"," Si cette option est activée, un diaporama sera affiché à la place des images individuelles. Autres paramètres sous « Diaporama »");
define("_CONF_BLOCK_SIDERHIGHT"," Hauteur du curseur en pixels ");
define("_CONF_BLOCK_SLIDERTYPE"," Ici, vous pouvez spécifier l'effet de transition entre les images ");
define("_CONF_BLOCK_SIDERDURATION"," Le temps de la transition dans ms ");
define("_CONF_BLOCK_SIDERDELAY"," Temps d'affichage des images en ms ");

// Nouveaux paramètres de bloc
define("_CONF_CATHIDDEN","Catégories interdites");
define("_CONF_CATHIDDEN_INFO","Spécifiez les identifiants de catégories à partir desquels les catégories ne doivent pas être affichées, séparés par des virgules. ");
define("_CONF_COLLECTION_SELECT","Sélection d'images");
define("_CONF_COLLECTION_SELECT_INFO","Sélectionnez ici quelles images doivent être affichées.");
define("_CONF_GALLERY_LINK","Afficher le lien de la galerie ?");
define("_CONF_GALLERY_LINK_TEXT","Un lien vers la galerie doit-il être affiché ?");
define("_CONF_BLOCK_SLIDESHOW_TEXT","Si activé, un diaporama sera affiché à la place des images individuelles. Autres paramètres sous 'Diaporama'");
define("_CONF_BLOCK_SIDERHIGHT","Hauteur du curseur en pixels");
define("_CONF_BLOCK_SLIDERTYPE","L'effet de transition entre les images peut être spécifié ici");
define("_CONF_BLOCK_SIDERDURATION","Durée de transition en ms");
define("_CONF_BLOCK_SIDERDELAY","Durée d'affichage des images en ms");
?>